package java.game.cars;

import java.game.*;
import java.util.*;
import java.game.parts.*;
import java.game.parts.enginepart.airfueldeliverysystem.*;

public class Yotta_chassis extends Yotta_models
{
	public Yotta_chassis( int id )
	{
		super( id );
		carCategory = PACKAGE;

		vehicleName = vendorName = "Yotta";
		name = getName();
		
		rID_blueprint = cars.cat_04.Yotta:0x018Ar;
		defColorIndex = GameLogic.CARCOLOR_ORANGE;
		
		game_version = 2.31;
		ban_mufflers = own_suspension = allow_missing_seats = 1;

		value = 13552;
 
		fully_stripped_drag = 0.55;
		min_drag = 0.318;
		drag_reduction_mul = 1.0;
		
		parts_shop_sml = new int[2];
		parts_shop_sml[0] = cars.cat_04.Yotta:0x01CDr; //Left taillight dark
		parts_shop_sml[1] = cars.cat_04.Yotta:0x01DBr; //Right taillight dark
		
		parts_shop_big = new int[2];
		parts_shop_big[0] = cars.cat_04.Yotta:0x00F5r; //Left exhaust
		parts_shop_big[1] = cars.cat_04.Yotta:0x00F4r; //right exhaust	
	}

	public void addStockParts( Descriptor desc )
	{
		int actcolor = desc.color;
		float optical = desc.optical;
		float power = desc.power;
		
		super.addStockParts( actcolor, optical, power );

		float part_random;

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_04.yotta:0x000000C8r, "FL door", actcolor, optical, power );
			addPart( cars.cat_04.yotta:0x000000CBr, "trunk", actcolor, optical, power );
			addPart( cars.cat_04.yotta:0x000000CCr, "targa top", actcolor, optical, power );
			addPart( cars.cat_04.yotta:0x000000CDr, "L taillights", actcolor, optical, power );
			addPart( cars.cat_04.yotta:0x000000CEr, "R seats", actcolor, optical, power );
			addPart( cars.cat_04.yotta:0x000000CFr, "F windshield", actcolor, optical, power );
			addPart( cars.cat_04.yotta:0x000000D3r, "RL window", actcolor, optical, power );
			addPart( cars.cat_04.yotta:0x000000D4r, "RR window", actcolor, optical, power );
			addPart( cars.cat_04.yotta:0x000000D8r, "L headlights", actcolor, optical, power );
			addPart( cars.cat_04.yotta:0x000000DAr, "R headlights", actcolor, optical, power );
			addPart( cars.cat_04.yotta:0x000000DBr, "R taillights", actcolor, optical, power );
			addPart( cars.cat_04.yotta:0x000000DCr, "FR door", actcolor, optical, power );
			addPart( cars.cat_04.yotta:0x000000EEr, "FL seat", actcolor, optical, power );
			addPart( cars.cat_04.yotta:0x000000EFr, "FR seat", actcolor, optical, power );
			addPart( cars.cat_04.yotta:0x000000F4r, "R exhaust pipe", actcolor, optical, power );
			addPart( cars.cat_04.yotta:0x000000F5r, "L exhaust pipe", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000C8r, "FL door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000CBr, "trunk", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000CCr, "targa top", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000CDr, "L taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000CEr, "R seats", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000CFr, "F windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000D3r, "RL window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000D4r, "RR window", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000D8r, "L headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000DAr, "R headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000DBr, "R taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000DCr, "FR door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000EEr, "FL seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000EFr, "FR seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000F4r, "R exhaust pipe", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000F5r, "L exhaust pipe", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000C9r, "R bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000CAr, "L sideskirt", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000D5r, "R sideskirt", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000DDr, "F bumper", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_04.yotta:0x000000E8r, "L sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_04.yotta:0x000000DEr, "L sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_04.yotta:0x000000CAr, "L sideskirt", actcolor, optical, power );

			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_04.yotta:0x000000E7r, "R sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_04.yotta:0x000000E3r, "R sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_04.yotta:0x000000D5r, "R sideskirt", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_04.yotta:0x000000EDr, "R bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_04.yotta:0x000000E0r, "R bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_04.yotta:0x000000C9r, "R bumper", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_04.yotta:0x000000ECr, "F bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_04.yotta:0x000000E5r, "F bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_04.yotta:0x000000DDr, "F bumper", actcolor, optical, power );
		}

		addPart( cars.cat_04.yotta:0x000000F0r, "RL suspension" );
		addPart( cars.cat_04.yotta:0x000000F1r, "FL suspension" );
		addPart( cars.cat_04.yotta:0x000000F2r, "FR suspension" );
		addPart( cars.cat_04.yotta:0x000000F3r, "RR suspension" );

		if ( optical < 1.0 )
		{
			addPart( parts.wheels_combo:0x000000B0r, "wheel" );
			addPart( parts.wheels_combo:0x000000B0r, "wheel" );
			addPart( parts.wheels_combo:0x000000B0r, "wheel" );
			addPart( parts.wheels_combo:0x000000B0r, "wheel" );

		} else
		{
			if ( random() > 0.5 ) // SI//
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 375-19R //
				{
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B5r, "wheel" );
					addPart( parts.wheels_combo:0x000000B5r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B4r, "wheel" );
					addPart( parts.wheels_combo:0x000000B4r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
				} else                             // 215-17F 255-17R Speed 6 //
				{
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000987r, "wheel" );
					addPart( parts.wheels_combo:0x00000987r, "wheel" );
				}
			} else
			if ( random() > 0.5 ) // Sparkler //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 375-19R //
				{
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B8r, "wheel" );
					addPart( parts.wheels_combo:0x000000B8r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B7r, "wheel" );
					addPart( parts.wheels_combo:0x000000B7r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
				} else                             // 215-17F 255-17R //
				{
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000096Ar, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
					addPart( parts.wheels_combo:0x00000985r, "wheel" );
				}
			} else                // Chromo //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 375-19R //
				{
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000ACr, "wheel" );
					addPart( parts.wheels_combo:0x000000ACr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000ABr, "wheel" );
					addPart( parts.wheels_combo:0x000000ABr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
				} else                             // 215-17F 255-17R Flat //
				{
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000095Ar, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
					addPart( parts.wheels_combo:0x00000962r, "wheel" );
				}
			}
		}

		if ( power >= 1.4 ) // Bilstein pro racer //
		{
			addPart( parts.running_gear:0x000001F8r, "shock" );
			addPart( parts.running_gear:0x000001F8r, "shock" );
			addPart( parts.running_gear:0x000001F9r, "shock" );
			addPart( parts.running_gear:0x000001F9r, "shock" );
		} else
		if ( power >= 1.2 ) // Bilstein street racer //
		{
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
		} else
		if ( power >= 1.1 ) // Bilstein aftermarket //
		{
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
		} else                // stock //
		{
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
		}

		if ( power >= 1.5 ) // H&R pro racer 58000 Nm 10" //
		{
			addPart( parts.running_gear:0x0000021Fr, "spring" );
			addPart( parts.running_gear:0x0000021Fr, "spring" );
			addPart( parts.running_gear:0x00000220r, "spring" );
			addPart( parts.running_gear:0x00000220r, "spring" );
		} else
		if ( power >= 1.25 ) // H&R aftermarket 36000 Nm 11" //
		{
			addPart( parts.running_gear:0x000001BDr, "spring" );
			addPart( parts.running_gear:0x000001BDr, "spring" );
			addPart( parts.running_gear:0x000001BEr, "spring" );
			addPart( parts.running_gear:0x000001BEr, "spring" );
		} else                // stock 32000Nm 12" //
		{
			addPart( parts.running_gear:0x0000021Dr, "spring" );
			addPart( parts.running_gear:0x0000021Dr, "spring" );
			addPart( parts.running_gear:0x0000021Er, "spring" );
			addPart( parts.running_gear:0x0000021Er, "spring" );
		}

		if ( power >= 1.3 ) // Baer carbon 12.5"F 13.0"R //
		{
			addPart( parts.running_gear:0x000000E2r, "FL brake" );
			addPart( parts.running_gear:0x000000E5r, "FR brake" );
			addPart( parts.running_gear:0x000000FAr, "RL brake" );
			addPart( parts.running_gear:0x000000FFr, "RR brake" );
		} else
		if ( power >= 1.15 ) // Baer grooved 12.5"F 12.5"R //
		{
			addPart( parts.running_gear:0x00000147r, "FL brake" );
			addPart( parts.running_gear:0x00000149r, "FR brake" );
			addPart( parts.running_gear:0x0000014Cr, "RL brake" );
			addPart( parts.running_gear:0x0000014Er, "RR brake" );
		} else              // Baer drilled 12.5"F 12.5"R //
		{
			addPart( parts.running_gear:0x00000108r, "FL brake" );
			addPart( parts.running_gear:0x00000132r, "FR brake" );
			addPart( parts.running_gear:0x00000136r, "RL brake" );
			addPart( parts.running_gear:0x00000146r, "RR brake" );
		}

		if ( power >= 1.25 ) // supersport //
		{
			addPart( parts.running_gear:0x00000164r, "F swaybar" );
			addPart( parts.running_gear:0x00000181r, "R swaybar" );
		} else              // sport //
		{
			addPart( parts.running_gear:0x00000154r, "F swaybar" );
			addPart( parts.running_gear:0x0000015Cr, "R swaybar" );
		}
		
		int supercharged;
		float enginePow;
		
		if ( power >= 1.833 )
		{
			enginePow = (power-1.833)/0.166*2;
			addPart( parts.engines.V8:0x0000000Cr, "10.0L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 1.666 )
		{
			enginePow = (power-1.666)/0.166*2;
			addPart( parts.engines.V8:0x0000000Br, "8.5L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 1.5 )
		{
			enginePow = (power-1.5)/0.166*2;
			addPart( parts.engines.V8:0x0000000Ar, "6.5L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 1.333 )
		{
			enginePow = (power-1.333)/0.166*2;
			addPart( parts.engines.V8:0x00000009r, "5.7L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 1.166 )
		{
			enginePow = (power-1.166)/0.166*2;
			addPart( parts.engines.V8:0x00000008r, "5.0L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 1 ) addPart( parts.engines.V6:0x00000008r, "4.0L V6 engine", actcolor, optical, (power-1)/0.166*2 ); else
		if ( power >= 0.75 ) addPart( parts.engines.V6:0x00000007r, "3.3L V6 engine", actcolor, optical, (1-power)/0.25*2 ); else
		if ( power >= 0.5 ) addPart( parts.engines.V6:0x00000060r, "2.8L V6 engine", actcolor, optical, (0.75-power)/0.25*2 );
		
		if(enginePow >= 1.50) supercharged++; //EvilMcSheep: Or at least has the sc intake manifold, which brings the intake too high as well
		
		if(!supercharged)
		{
			if ( optical <= 1.0 )
			{
				if ( optical >= random() ) addPart( cars.cat_04.yotta:0x000000D7r, "hood", actcolor, optical, power );
			} else
			{
				part_random = random();
				if ( optical-1 >= 0.66667 ) addPart( cars.cat_04.yotta:0x000000E6r, "hood 3", actcolor, optical, power ); else
				if ( optical-1 >= 0.33333 ) addPart( cars.cat_04.yotta:0x000000E1r, "hood 2", actcolor, optical, power ); else
				addPart( cars.cat_04.yotta:0x000000D7r, "hood", actcolor, optical, power );
			}
		}
		
		if ( power >= 1.35 ) addPart( parts:0x000000E9r, "silver battery" ); else
		addPart( parts:0x000000E8r, "blue battery" );
		
		addPart( cars.cat_04.Yotta:0x0000FFB4r, "steering wheel" );
	}
	
	public void setDrive(int fwd, int rwd, float drive_front)
	{
		if((fwd && !rwd) || (rwd && !fwd)) super.setDrive(0,1,0.0); //2WD all becomes RWD
		else super.setDrive(fwd, rwd, drive_front); //Leave AWD alone 
	}
}
